// This is Free software.
// License BSD ( you can profit from it but then send me some cash (or a bottle of scotch))
// 08 Feb 2011 by Thimios Katsoulis , info@pure-ingredients.net , thkatsou@yahoo.gr
// More work and contact at www.pure-ingredients.net

function DamnSimpleSlideshow(containerId){
	
this.ContainerId = containerId;
this.Divs=[];
this.TransStep=0.01;
this.TransDelay=10; // (ms) - transition delay when fading in/out  
this.Delay=4000; // (ms) - Delay to switch between images

this.initialize= function (){
		 
	containerD=document.getElementById(this.ContainerId);
	this.Divs=containerD.getElementsByTagName('div');
	
	for (i=0;i<this.Divs.length;i++){
		d=this.Divs[i];
		d.className='slideElement';
		img=d.getElementsByTagName("img")[0];
		 		
		d.style.position='absolute';
		d.style.left='0px';
		d.style.right='0px';
		d.style.margin='0px';
		d.style.backgroundPosition='center center';
		d.style.backgroundImage="url('" + img.src + "')";
		 	 
		d.removeChild(img);
		
		if (i==0)op=1; else op=0;
		this.setOp(d,op);
		
		}
	this.CurIndex=0;
	this.NewIndex=1;
	
	setTimeout(methodize(this.slide,this),  this.Delay);
};

this.setOp= function (el,value) {
	value=Math.round(value*100)/100 ;
	el.style.opacity = value;
	el.style.filter = 'alpha(opacity=' + value*100 + ')';
};

this.addToOp= function (el,step) {
	newop=parseFloat(el.style.opacity)+step;
	this.setOp(el,newop);	
};

this.slide= function () {
	 
	 if (parseFloat(this.Divs[this.CurIndex].style.opacity ) > 0 ){
		 
		 this.addToOp(this.Divs[this.CurIndex] , - this.TransStep);
		 this.addToOp(this.Divs[this.NewIndex] , this.TransStep);
		 
		 setTimeout(methodize(this.slide,this),  this.TransDelay);
	 }
	 else{
		 
		 this.setOp(this.Divs[this.CurIndex] ,0);
		 this.setOp(this.Divs[this.NewIndex] ,1);
		 
		 this.NewIndex += 1; 
		 if (this.NewIndex == this.Divs.length){this.NewIndex = 0;}
		 this.CurIndex += 1; 
		 if (this.CurIndex == this.Divs.length){this.CurIndex = 0;}
		 
		 setTimeout(methodize(this.slide,this),  this.Delay);
	 }	
};

}; //end DamnSimpleSlideShow


function methodize(methodize_func,methodize_scope){
	return (function(){methodize_func.call(methodize_scope);});
}


function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      if (oldonload) {
        oldonload();
      }
      func();
    }
  }
}